/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.bgp.eui;

import ibm.nways.bgp.model.PathModel;
import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavInitialRow;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.RemoteModelWithStatus;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.eui.EuiGrid;
import ibm.nways.jdm.eui.EuiGridEvent;
import ibm.nways.jdm.eui.EuiGridListener;
import ibm.nways.jdm.eui.HexInput;
import ibm.nways.jdm.eui.HexInputRO;
import ibm.nways.jdm.eui.IPInput;
import ibm.nways.jdm.eui.JDMInput;
import ibm.nways.jdm.eui.NumericInput;
import ibm.nways.jdm.eui.PropertySection;
import ibm.nways.jdm.eui.SingleChoiceInput;
import ibm.nways.jdm.eui.SingleChoiceInputRO;
import ibm.nways.jdm.eui.StringInputRO;
import ibm.nways.jdm.eui.Table;
import ibm.nways.jdm.eui.TableColumn;
import ibm.nways.jdm.eui.TableColumns;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.TableStatus;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class BgpPathPanel
extends DestinationPropBook {
    protected static ResourceBundle enumStrings = null;
    protected static ResourceBundle myResources = null;
    private static String title = "BGP Path";
    protected boolean containsWritableField = false;
    protected boolean containsCreatableField = false;
    protected GenModel Path_model;
    protected selectionListSection selectionListPropertySection;
    protected bgpPathAttrDetailSection bgpPathAttrDetailPropertySection;
    protected ModelInfo Bgp4PathAttrTableInfo;
    protected ModelInfo PanelInfo;
    protected ModelInfo IndexInfo;
    protected int Bgp4PathAttrTableIndex;
    protected Bgp4PathAttrTable Bgp4PathAttrTableData;
    protected TableColumns Bgp4PathAttrTableColumns;
    protected TableStatus Bgp4PathAttrTableStatus;
    protected static TableColumn[] Bgp4PathAttrTableCols = new TableColumn[]{new TableColumn("Index.Bgp4PathAttrIpAddrPrefix", "IP Address Prefix", 4, true), new TableColumn("Index.Bgp4PathAttrIpAddrPrefixLen", "Prefix Length", 3, true), new TableColumn("Index.Bgp4PathAttrPeer", "IP Address", 4, true)};
    protected boolean errorsFound = false;

    private static void loadStatics() {
        try {
            if (enumStrings == null) {
                enumStrings = ResourceBundle.getBundle("ibm.nways.bgp.eui.EnumeratedResources");
            }
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.bgp.eui.BgpPathPanelResources");
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Unable to access translation resources for panel BgpPath");
        }
    }

    public static String getTitle() {
        BgpPathPanel.loadStatics();
        if (myResources != null) {
            title = BgpPathPanel.getNLSString("BgpPathPanelTitle");
        }
        return title;
    }

    private static ResourceBundle getEnumStrings() {
        if (enumStrings == null) {
            BgpPathPanel.loadStatics();
        }
        return enumStrings;
    }

    public BgpPathPanel() {
        BgpPathPanel.loadStatics();
    }

    public Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    public String getDestinationTitle() {
        return BgpPathPanel.getTitle();
    }

    protected void getModels() {
        this.Path_model = (GenModel)this.getModel();
    }

    public void addSections() {
        this.getModels();
        this.createTables();
        this.addselectionListSection();
        this.addbgpPathAttrDetailSection();
        if (this.containsCreatableField) {
            this.addCreateButton();
        }
        if (this.containsWritableField) {
            this.addApplyButton();
        }
        this.addRefreshButton();
        this.addHelpButton();
        this.reset();
    }

    protected void addselectionListSection() {
        this.selectionListPropertySection = new selectionListSection();
        this.selectionListPropertySection.layoutSection();
        this.addSection(BgpPathPanel.getNLSString("selectionListSectionTitle"), this.selectionListPropertySection);
    }

    protected void addbgpPathAttrDetailSection() {
        this.bgpPathAttrDetailPropertySection = new bgpPathAttrDetailSection();
        this.bgpPathAttrDetailPropertySection.layoutSection();
        this.addSection(BgpPathPanel.getNLSString("bgpPathAttrDetailSectionTitle"), this.bgpPathAttrDetailPropertySection);
    }

    protected void panelRowChange() {
        if (this.selectionListPropertySection != null) {
            this.selectionListPropertySection.rowChange();
        }
        if (this.bgpPathAttrDetailPropertySection != null) {
            this.bgpPathAttrDetailPropertySection.rowChange();
        }
    }

    public void filterPanelInfos(Vector vector) {
    }

    public int getInitialBgp4PathAttrTableRow() {
        return 0;
    }

    public ModelInfo initialBgp4PathAttrTableRow() {
        ModelInfo modelInfo = null;
        if (this.getNavContext() instanceof NavigationContext) {
            modelInfo = NavInitialRow.getInitialRow(this.getNavContext(), true);
        }
        return modelInfo;
    }

    protected void displayMsg(String string) {
        if (this.getBrowser() != null) {
            this.getBrowser().displayMsg(string);
        }
    }

    protected static String getNLSString(String string) {
        if (myResources == null) {
            return string;
        }
        try {
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    protected String getOverride(String string, String string2) {
        String string3 = null;
        try {
            string3 = NavFieldOverride.getFieldOverride(this.getNavContext(), string);
        }
        catch (ClassCastException classCastException) {
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (NullPointerException nullPointerException) {}
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public void reset() {
        this.displayMsg(BgpPathPanel.getNLSString("startResetMsg"));
        this.Bgp4PathAttrTableData.invalidate();
        this.errorsFound = false;
        super.reset();
        if (!this.errorsFound) {
            this.displayMsg(BgpPathPanel.getNLSString("endResetMsg"));
            return;
        }
        this.displayMsg(String.valueOf(BgpPathPanel.getNLSString("endResetMsg")) + " " + BgpPathPanel.getNLSString("noteErrorsMsg"));
    }

    public void apply() {
        this.IndexInfo = new ModelInfo();
        this.errorsFound = false;
        this.displayMsg(BgpPathPanel.getNLSString("startApplyMsg"));
        super.apply();
        if (!this.errorsFound) {
            this.Bgp4PathAttrTableInfo = (ModelInfo)this.Bgp4PathAttrTableData.elementAt(this.Bgp4PathAttrTableIndex);
            this.Bgp4PathAttrTableInfo = this.Bgp4PathAttrTableData.setRow();
            this.Bgp4PathAttrTableData.setElementAt(this.Bgp4PathAttrTableInfo, this.Bgp4PathAttrTableIndex);
            super.reset();
            if (!this.errorsFound) {
                this.displayMsg(BgpPathPanel.getNLSString("endApplyMsg"));
                return;
            }
            this.displayMsg(String.valueOf(BgpPathPanel.getNLSString("endApplyMsg")) + " " + BgpPathPanel.getNLSString("noteErrorsMsg"));
            return;
        }
        this.displayMsg(BgpPathPanel.getNLSString("abortApplyMsg"));
    }

    public void createTables() {
        this.Bgp4PathAttrTableData = new Bgp4PathAttrTable();
        this.Bgp4PathAttrTableIndex = 0;
        this.Bgp4PathAttrTableColumns = new TableColumns(Bgp4PathAttrTableCols);
        if (this.Path_model instanceof RemoteModelWithStatus) {
            try {
                this.Bgp4PathAttrTableStatus = (TableStatus)this.Path_model.getStatus();
                return;
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
                return;
            }
        }
    }

    public class selectionListSection
    extends PropertySection
    implements EuiGridListener {
        ModelInfo chunk;
        Component Bgp4PathAttrTableField;
        Label Bgp4PathAttrTableFieldLabel;
        boolean Bgp4PathAttrTableFieldWritable = false;

        public selectionListSection() {
            BgpPathPanel.this = BgpPathPanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createBgp4PathAttrTableField() {
            EuiGrid euiGrid = new EuiGrid(BgpPathPanel.this.Bgp4PathAttrTableData, BgpPathPanel.this.Bgp4PathAttrTableColumns, false);
            euiGrid.addRows(5);
            euiGrid.addEuiGridListener(this);
            euiGrid.setInitialRow(BgpPathPanel.this.initialBgp4PathAttrTableRow());
            this.addTable(BgpPathPanel.getNLSString("Bgp4PathAttrTableLabel"), euiGrid);
            return euiGrid;
        }

        public void layoutSection() {
            this.Bgp4PathAttrTableField = this.createBgp4PathAttrTableField();
        }

        public void apply() {
            if (!this.validateSection()) {
                BgpPathPanel.this.errorsFound = true;
            }
        }

        public void reset() {
            BgpPathPanel.this.displayMsg(BgpPathPanel.getNLSString("accessDataMsg"));
            BgpPathPanel.this.displayMsg(BgpPathPanel.getNLSString("startTableGetMsg"));
            ((EuiGrid)this.Bgp4PathAttrTableField).refresh();
            BgpPathPanel.this.displayMsg(BgpPathPanel.getNLSString("endTableGetMsg"));
            BgpPathPanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.doLayout();
        }

        public boolean validateSection() {
            return true;
        }

        public void onEuiGridEvent(EuiGridEvent euiGridEvent) {
            System.out.println("Event received in section");
            if (euiGridEvent.getType() == 2001) {
                try {
                    if (euiGridEvent.getSource() == this.Bgp4PathAttrTableField) {
                        BgpPathPanel.this.Bgp4PathAttrTableIndex = euiGridEvent.getRow();
                    }
                    BgpPathPanel.this.Bgp4PathAttrTableIndex = euiGridEvent.getRow();
                    ((EuiGrid)this.Bgp4PathAttrTableField).deselectAllRows();
                    BgpPathPanel.this.panelRowChange();
                    return;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    EuiGrid euiGrid = (EuiGrid)euiGridEvent.getSource();
                    euiGrid.deleteAllRows();
                    if (euiGridEvent.getSource() == this.Bgp4PathAttrTableField) {
                        BgpPathPanel.this.Bgp4PathAttrTableIndex = 0;
                    }
                    BgpPathPanel.this.selectionListPropertySection.reset();
                    BgpPathPanel.this.bgpPathAttrDetailPropertySection.reset();
                    return;
                }
            }
        }
    }

    public class bgpPathAttrDetailSection
    extends PropertySection {
        ModelInfo chunk;
        Component bgp4PathAttrPeerField;
        Component bgp4PathAttrIpAddrPrefixLenField;
        Component bgp4PathAttrIpAddrPrefixField;
        Component bgp4PathAttrOriginField;
        Component bgp4PathAttrASPathSegmentField;
        Component bgp4PathAttrNextHopField;
        Component bgp4PathAttrMultiExitDiscField;
        Component bgp4PathAttrLocalPrefField;
        Component bgp4PathAttrAtomicAggregateField;
        Component bgp4PathAttrAggregatorASField;
        Component bgp4PathAttrAggregatorAddrField;
        Component bgp4PathAttrCalcLocalPrefField;
        Component bgp4PathAttrBestField;
        Label bgp4PathAttrPeerFieldLabel;
        Label bgp4PathAttrIpAddrPrefixLenFieldLabel;
        Label bgp4PathAttrIpAddrPrefixFieldLabel;
        Label bgp4PathAttrOriginFieldLabel;
        Label bgp4PathAttrASPathSegmentFieldLabel;
        Label bgp4PathAttrNextHopFieldLabel;
        Label bgp4PathAttrMultiExitDiscFieldLabel;
        Label bgp4PathAttrLocalPrefFieldLabel;
        Label bgp4PathAttrAtomicAggregateFieldLabel;
        Label bgp4PathAttrAggregatorASFieldLabel;
        Label bgp4PathAttrAggregatorAddrFieldLabel;
        Label bgp4PathAttrCalcLocalPrefFieldLabel;
        Label bgp4PathAttrBestFieldLabel;
        boolean bgp4PathAttrPeerFieldWritable = false;
        boolean bgp4PathAttrIpAddrPrefixLenFieldWritable = false;
        boolean bgp4PathAttrIpAddrPrefixFieldWritable = false;
        boolean bgp4PathAttrOriginFieldWritable = false;
        boolean bgp4PathAttrASPathSegmentFieldWritable = false;
        boolean bgp4PathAttrNextHopFieldWritable = false;
        boolean bgp4PathAttrMultiExitDiscFieldWritable = false;
        boolean bgp4PathAttrLocalPrefFieldWritable = false;
        boolean bgp4PathAttrAtomicAggregateFieldWritable = false;
        boolean bgp4PathAttrAggregatorASFieldWritable = false;
        boolean bgp4PathAttrAggregatorAddrFieldWritable = false;
        boolean bgp4PathAttrCalcLocalPrefFieldWritable = false;
        boolean bgp4PathAttrBestFieldWritable = false;

        public bgpPathAttrDetailSection() {
            BgpPathPanel.this = BgpPathPanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createbgp4PathAttrPeerField() {
            String string = BgpPathPanel.this.getOverride("ibm.nways.bgp.model.Path.Index.Bgp4PathAttrPeer.access", "unknown");
            this.bgp4PathAttrPeerFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgp4PathAttrPeerFieldLabel = new Label(BgpPathPanel.getNLSString("bgp4PathAttrPeerLabel"), 2);
            if (this.bgp4PathAttrPeerFieldWritable) {
                IPInput iPInput = new IPInput();
                this.addRow(this.bgp4PathAttrPeerFieldLabel, (Component)iPInput);
                BgpPathPanel.this.containsWritableField = true;
                return iPInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.bgp4PathAttrPeerFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getbgp4PathAttrPeerField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrPeerField);
            this.validatebgp4PathAttrPeerField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgp4PathAttrPeerField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrPeerField);
                jDMInput.setValue(object);
                this.validatebgp4PathAttrPeerField();
            }
        }

        protected boolean validatebgp4PathAttrPeerField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrPeerField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgp4PathAttrPeerFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgp4PathAttrPeerFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgp4PathAttrIpAddrPrefixLenField() {
            String string = BgpPathPanel.this.getOverride("ibm.nways.bgp.model.Path.Index.Bgp4PathAttrIpAddrPrefixLen.access", "unknown");
            this.bgp4PathAttrIpAddrPrefixLenFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgp4PathAttrIpAddrPrefixLenFieldLabel = new Label(BgpPathPanel.getNLSString("bgp4PathAttrIpAddrPrefixLenLabel"), 2);
            if (this.bgp4PathAttrIpAddrPrefixLenFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 32);
                this.addRow(this.bgp4PathAttrIpAddrPrefixLenFieldLabel, (Component)numericInput);
                BgpPathPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.bgp4PathAttrIpAddrPrefixLenFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getbgp4PathAttrIpAddrPrefixLenField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrIpAddrPrefixLenField);
            this.validatebgp4PathAttrIpAddrPrefixLenField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgp4PathAttrIpAddrPrefixLenField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrIpAddrPrefixLenField);
                jDMInput.setValue(object);
                this.validatebgp4PathAttrIpAddrPrefixLenField();
            }
        }

        protected boolean validatebgp4PathAttrIpAddrPrefixLenField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrIpAddrPrefixLenField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgp4PathAttrIpAddrPrefixLenFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgp4PathAttrIpAddrPrefixLenFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgp4PathAttrIpAddrPrefixField() {
            String string = BgpPathPanel.this.getOverride("ibm.nways.bgp.model.Path.Index.Bgp4PathAttrIpAddrPrefix.access", "unknown");
            this.bgp4PathAttrIpAddrPrefixFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgp4PathAttrIpAddrPrefixFieldLabel = new Label(BgpPathPanel.getNLSString("bgp4PathAttrIpAddrPrefixLabel"), 2);
            if (this.bgp4PathAttrIpAddrPrefixFieldWritable) {
                IPInput iPInput = new IPInput();
                this.addRow(this.bgp4PathAttrIpAddrPrefixFieldLabel, (Component)iPInput);
                BgpPathPanel.this.containsWritableField = true;
                return iPInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.bgp4PathAttrIpAddrPrefixFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getbgp4PathAttrIpAddrPrefixField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrIpAddrPrefixField);
            this.validatebgp4PathAttrIpAddrPrefixField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgp4PathAttrIpAddrPrefixField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrIpAddrPrefixField);
                jDMInput.setValue(object);
                this.validatebgp4PathAttrIpAddrPrefixField();
            }
        }

        protected boolean validatebgp4PathAttrIpAddrPrefixField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrIpAddrPrefixField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgp4PathAttrIpAddrPrefixFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgp4PathAttrIpAddrPrefixFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgp4PathAttrOriginField() {
            String string = BgpPathPanel.this.getOverride("ibm.nways.bgp.model.Path.Panel.Bgp4PathAttrOrigin.access", "read-only");
            this.bgp4PathAttrOriginFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgp4PathAttrOriginFieldLabel = new Label(BgpPathPanel.getNLSString("bgp4PathAttrOriginLabel"), 2);
            if (this.bgp4PathAttrOriginFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(PathModel.Panel.Bgp4PathAttrOriginEnum.symbolicValues, PathModel.Panel.Bgp4PathAttrOriginEnum.numericValues, BgpPathPanel.getEnumStrings());
                this.addRow(this.bgp4PathAttrOriginFieldLabel, (Component)singleChoiceInput);
                BgpPathPanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(PathModel.Panel.Bgp4PathAttrOriginEnum.symbolicValues, PathModel.Panel.Bgp4PathAttrOriginEnum.numericValues, BgpPathPanel.getEnumStrings());
            this.addRow(this.bgp4PathAttrOriginFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getbgp4PathAttrOriginField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrOriginField);
            this.validatebgp4PathAttrOriginField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgp4PathAttrOriginField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrOriginField);
                jDMInput.setValue(object);
                this.validatebgp4PathAttrOriginField();
            }
        }

        protected boolean validatebgp4PathAttrOriginField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrOriginField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgp4PathAttrOriginFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgp4PathAttrOriginFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgp4PathAttrASPathSegmentField() {
            String string = BgpPathPanel.this.getOverride("ibm.nways.bgp.model.Path.Panel.Bgp4PathAttrASPathSegment.access", "read-only");
            String string2 = BgpPathPanel.this.getOverride("ibm.nways.bgp.model.Path.Panel.Bgp4PathAttrASPathSegment.length", "255");
            this.bgp4PathAttrASPathSegmentFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgp4PathAttrASPathSegmentFieldLabel = new Label(BgpPathPanel.getNLSString("bgp4PathAttrASPathSegmentLabel"), 2);
            if (this.bgp4PathAttrASPathSegmentFieldWritable) {
                HexInput hexInput = new HexInput();
                hexInput.setMaxLength(Integer.parseInt(string2));
                this.addRow(this.bgp4PathAttrASPathSegmentFieldLabel, (Component)hexInput);
                BgpPathPanel.this.containsWritableField = true;
                return hexInput;
            }
            HexInputRO hexInputRO = new HexInputRO();
            this.addRow(this.bgp4PathAttrASPathSegmentFieldLabel, (Component)hexInputRO);
            return hexInputRO;
        }

        protected Serializable getbgp4PathAttrASPathSegmentField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrASPathSegmentField);
            this.validatebgp4PathAttrASPathSegmentField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgp4PathAttrASPathSegmentField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrASPathSegmentField);
                jDMInput.setValue(object);
                this.validatebgp4PathAttrASPathSegmentField();
            }
        }

        protected boolean validatebgp4PathAttrASPathSegmentField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrASPathSegmentField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgp4PathAttrASPathSegmentFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgp4PathAttrASPathSegmentFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgp4PathAttrNextHopField() {
            String string = BgpPathPanel.this.getOverride("ibm.nways.bgp.model.Path.Panel.Bgp4PathAttrNextHop.access", "read-only");
            this.bgp4PathAttrNextHopFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgp4PathAttrNextHopFieldLabel = new Label(BgpPathPanel.getNLSString("bgp4PathAttrNextHopLabel"), 2);
            if (this.bgp4PathAttrNextHopFieldWritable) {
                IPInput iPInput = new IPInput();
                this.addRow(this.bgp4PathAttrNextHopFieldLabel, (Component)iPInput);
                BgpPathPanel.this.containsWritableField = true;
                return iPInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.bgp4PathAttrNextHopFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getbgp4PathAttrNextHopField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrNextHopField);
            this.validatebgp4PathAttrNextHopField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgp4PathAttrNextHopField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrNextHopField);
                jDMInput.setValue(object);
                this.validatebgp4PathAttrNextHopField();
            }
        }

        protected boolean validatebgp4PathAttrNextHopField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrNextHopField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgp4PathAttrNextHopFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgp4PathAttrNextHopFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgp4PathAttrMultiExitDiscField() {
            String string = BgpPathPanel.this.getOverride("ibm.nways.bgp.model.Path.Panel.Bgp4PathAttrMultiExitDisc.access", "read-only");
            this.bgp4PathAttrMultiExitDiscFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgp4PathAttrMultiExitDiscFieldLabel = new Label(BgpPathPanel.getNLSString("bgp4PathAttrMultiExitDiscLabel"), 2);
            if (this.bgp4PathAttrMultiExitDiscFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(-1, Integer.MAX_VALUE);
                this.addRow(this.bgp4PathAttrMultiExitDiscFieldLabel, (Component)numericInput);
                BgpPathPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.bgp4PathAttrMultiExitDiscFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getbgp4PathAttrMultiExitDiscField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrMultiExitDiscField);
            this.validatebgp4PathAttrMultiExitDiscField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgp4PathAttrMultiExitDiscField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrMultiExitDiscField);
                jDMInput.setValue(object);
                this.validatebgp4PathAttrMultiExitDiscField();
            }
        }

        protected boolean validatebgp4PathAttrMultiExitDiscField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrMultiExitDiscField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgp4PathAttrMultiExitDiscFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgp4PathAttrMultiExitDiscFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgp4PathAttrLocalPrefField() {
            String string = BgpPathPanel.this.getOverride("ibm.nways.bgp.model.Path.Panel.Bgp4PathAttrLocalPref.access", "read-only");
            this.bgp4PathAttrLocalPrefFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgp4PathAttrLocalPrefFieldLabel = new Label(BgpPathPanel.getNLSString("bgp4PathAttrLocalPrefLabel"), 2);
            if (this.bgp4PathAttrLocalPrefFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(-1, Integer.MAX_VALUE);
                this.addRow(this.bgp4PathAttrLocalPrefFieldLabel, (Component)numericInput);
                BgpPathPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.bgp4PathAttrLocalPrefFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getbgp4PathAttrLocalPrefField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrLocalPrefField);
            this.validatebgp4PathAttrLocalPrefField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgp4PathAttrLocalPrefField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrLocalPrefField);
                jDMInput.setValue(object);
                this.validatebgp4PathAttrLocalPrefField();
            }
        }

        protected boolean validatebgp4PathAttrLocalPrefField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrLocalPrefField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgp4PathAttrLocalPrefFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgp4PathAttrLocalPrefFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgp4PathAttrAtomicAggregateField() {
            String string = BgpPathPanel.this.getOverride("ibm.nways.bgp.model.Path.Panel.Bgp4PathAttrAtomicAggregate.access", "read-only");
            this.bgp4PathAttrAtomicAggregateFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgp4PathAttrAtomicAggregateFieldLabel = new Label(BgpPathPanel.getNLSString("bgp4PathAttrAtomicAggregateLabel"), 2);
            if (this.bgp4PathAttrAtomicAggregateFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(PathModel.Panel.Bgp4PathAttrAtomicAggregateEnum.symbolicValues, PathModel.Panel.Bgp4PathAttrAtomicAggregateEnum.numericValues, BgpPathPanel.getEnumStrings());
                this.addRow(this.bgp4PathAttrAtomicAggregateFieldLabel, (Component)singleChoiceInput);
                BgpPathPanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(PathModel.Panel.Bgp4PathAttrAtomicAggregateEnum.symbolicValues, PathModel.Panel.Bgp4PathAttrAtomicAggregateEnum.numericValues, BgpPathPanel.getEnumStrings());
            this.addRow(this.bgp4PathAttrAtomicAggregateFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getbgp4PathAttrAtomicAggregateField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrAtomicAggregateField);
            this.validatebgp4PathAttrAtomicAggregateField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgp4PathAttrAtomicAggregateField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrAtomicAggregateField);
                jDMInput.setValue(object);
                this.validatebgp4PathAttrAtomicAggregateField();
            }
        }

        protected boolean validatebgp4PathAttrAtomicAggregateField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrAtomicAggregateField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgp4PathAttrAtomicAggregateFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgp4PathAttrAtomicAggregateFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgp4PathAttrAggregatorASField() {
            String string = BgpPathPanel.this.getOverride("ibm.nways.bgp.model.Path.Panel.Bgp4PathAttrAggregatorAS.access", "read-only");
            this.bgp4PathAttrAggregatorASFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgp4PathAttrAggregatorASFieldLabel = new Label(BgpPathPanel.getNLSString("bgp4PathAttrAggregatorASLabel"), 2);
            if (this.bgp4PathAttrAggregatorASFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 65535);
                this.addRow(this.bgp4PathAttrAggregatorASFieldLabel, (Component)numericInput);
                BgpPathPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.bgp4PathAttrAggregatorASFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getbgp4PathAttrAggregatorASField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrAggregatorASField);
            this.validatebgp4PathAttrAggregatorASField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgp4PathAttrAggregatorASField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrAggregatorASField);
                jDMInput.setValue(object);
                this.validatebgp4PathAttrAggregatorASField();
            }
        }

        protected boolean validatebgp4PathAttrAggregatorASField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrAggregatorASField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgp4PathAttrAggregatorASFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgp4PathAttrAggregatorASFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgp4PathAttrAggregatorAddrField() {
            String string = BgpPathPanel.this.getOverride("ibm.nways.bgp.model.Path.Panel.Bgp4PathAttrAggregatorAddr.access", "read-only");
            this.bgp4PathAttrAggregatorAddrFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgp4PathAttrAggregatorAddrFieldLabel = new Label(BgpPathPanel.getNLSString("bgp4PathAttrAggregatorAddrLabel"), 2);
            if (this.bgp4PathAttrAggregatorAddrFieldWritable) {
                IPInput iPInput = new IPInput();
                this.addRow(this.bgp4PathAttrAggregatorAddrFieldLabel, (Component)iPInput);
                BgpPathPanel.this.containsWritableField = true;
                return iPInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.bgp4PathAttrAggregatorAddrFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getbgp4PathAttrAggregatorAddrField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrAggregatorAddrField);
            this.validatebgp4PathAttrAggregatorAddrField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgp4PathAttrAggregatorAddrField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrAggregatorAddrField);
                jDMInput.setValue(object);
                this.validatebgp4PathAttrAggregatorAddrField();
            }
        }

        protected boolean validatebgp4PathAttrAggregatorAddrField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrAggregatorAddrField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgp4PathAttrAggregatorAddrFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgp4PathAttrAggregatorAddrFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgp4PathAttrCalcLocalPrefField() {
            String string = BgpPathPanel.this.getOverride("ibm.nways.bgp.model.Path.Panel.Bgp4PathAttrCalcLocalPref.access", "read-only");
            this.bgp4PathAttrCalcLocalPrefFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgp4PathAttrCalcLocalPrefFieldLabel = new Label(BgpPathPanel.getNLSString("bgp4PathAttrCalcLocalPrefLabel"), 2);
            if (this.bgp4PathAttrCalcLocalPrefFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(-1, Integer.MAX_VALUE);
                this.addRow(this.bgp4PathAttrCalcLocalPrefFieldLabel, (Component)numericInput);
                BgpPathPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.bgp4PathAttrCalcLocalPrefFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getbgp4PathAttrCalcLocalPrefField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrCalcLocalPrefField);
            this.validatebgp4PathAttrCalcLocalPrefField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgp4PathAttrCalcLocalPrefField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrCalcLocalPrefField);
                jDMInput.setValue(object);
                this.validatebgp4PathAttrCalcLocalPrefField();
            }
        }

        protected boolean validatebgp4PathAttrCalcLocalPrefField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrCalcLocalPrefField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgp4PathAttrCalcLocalPrefFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgp4PathAttrCalcLocalPrefFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgp4PathAttrBestField() {
            String string = BgpPathPanel.this.getOverride("ibm.nways.bgp.model.Path.Panel.Bgp4PathAttrBest.access", "read-only");
            this.bgp4PathAttrBestFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgp4PathAttrBestFieldLabel = new Label(BgpPathPanel.getNLSString("bgp4PathAttrBestLabel"), 2);
            if (this.bgp4PathAttrBestFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(PathModel.Panel.Bgp4PathAttrBestEnum.symbolicValues, PathModel.Panel.Bgp4PathAttrBestEnum.numericValues, BgpPathPanel.getEnumStrings());
                this.addRow(this.bgp4PathAttrBestFieldLabel, (Component)singleChoiceInput);
                BgpPathPanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(PathModel.Panel.Bgp4PathAttrBestEnum.symbolicValues, PathModel.Panel.Bgp4PathAttrBestEnum.numericValues, BgpPathPanel.getEnumStrings());
            this.addRow(this.bgp4PathAttrBestFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getbgp4PathAttrBestField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrBestField);
            this.validatebgp4PathAttrBestField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgp4PathAttrBestField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrBestField);
                jDMInput.setValue(object);
                this.validatebgp4PathAttrBestField();
            }
        }

        protected boolean validatebgp4PathAttrBestField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgp4PathAttrBestField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgp4PathAttrBestFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgp4PathAttrBestFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        public void layoutSection() {
            this.bgp4PathAttrPeerField = this.createbgp4PathAttrPeerField();
            this.bgp4PathAttrIpAddrPrefixLenField = this.createbgp4PathAttrIpAddrPrefixLenField();
            this.bgp4PathAttrIpAddrPrefixField = this.createbgp4PathAttrIpAddrPrefixField();
            this.bgp4PathAttrOriginField = this.createbgp4PathAttrOriginField();
            this.bgp4PathAttrASPathSegmentField = this.createbgp4PathAttrASPathSegmentField();
            this.bgp4PathAttrNextHopField = this.createbgp4PathAttrNextHopField();
            this.bgp4PathAttrMultiExitDiscField = this.createbgp4PathAttrMultiExitDiscField();
            this.bgp4PathAttrLocalPrefField = this.createbgp4PathAttrLocalPrefField();
            this.bgp4PathAttrAtomicAggregateField = this.createbgp4PathAttrAtomicAggregateField();
            this.bgp4PathAttrAggregatorASField = this.createbgp4PathAttrAggregatorASField();
            this.bgp4PathAttrAggregatorAddrField = this.createbgp4PathAttrAggregatorAddrField();
            this.bgp4PathAttrCalcLocalPrefField = this.createbgp4PathAttrCalcLocalPrefField();
            this.bgp4PathAttrBestField = this.createbgp4PathAttrBestField();
        }

        public void apply() {
            if (this.validateSection()) {
                if (!((JDMInput)((Object)this.bgp4PathAttrPeerField)).ignoreValue() && this.bgp4PathAttrPeerFieldWritable) {
                    BgpPathPanel.this.IndexInfo.add("Index.Bgp4PathAttrPeer", this.getbgp4PathAttrPeerField());
                }
                if (!((JDMInput)((Object)this.bgp4PathAttrIpAddrPrefixLenField)).ignoreValue() && this.bgp4PathAttrIpAddrPrefixLenFieldWritable) {
                    BgpPathPanel.this.IndexInfo.add("Index.Bgp4PathAttrIpAddrPrefixLen", this.getbgp4PathAttrIpAddrPrefixLenField());
                }
                if (!((JDMInput)((Object)this.bgp4PathAttrIpAddrPrefixField)).ignoreValue() && this.bgp4PathAttrIpAddrPrefixFieldWritable) {
                    BgpPathPanel.this.IndexInfo.add("Index.Bgp4PathAttrIpAddrPrefix", this.getbgp4PathAttrIpAddrPrefixField());
                }
                if (!((JDMInput)((Object)this.bgp4PathAttrOriginField)).ignoreValue() && this.bgp4PathAttrOriginFieldWritable) {
                    BgpPathPanel.this.PanelInfo.add("Panel.Bgp4PathAttrOrigin", this.getbgp4PathAttrOriginField());
                }
                if (!((JDMInput)((Object)this.bgp4PathAttrASPathSegmentField)).ignoreValue() && this.bgp4PathAttrASPathSegmentFieldWritable) {
                    BgpPathPanel.this.PanelInfo.add("Panel.Bgp4PathAttrASPathSegment", this.getbgp4PathAttrASPathSegmentField());
                }
                if (!((JDMInput)((Object)this.bgp4PathAttrNextHopField)).ignoreValue() && this.bgp4PathAttrNextHopFieldWritable) {
                    BgpPathPanel.this.PanelInfo.add("Panel.Bgp4PathAttrNextHop", this.getbgp4PathAttrNextHopField());
                }
                if (!((JDMInput)((Object)this.bgp4PathAttrMultiExitDiscField)).ignoreValue() && this.bgp4PathAttrMultiExitDiscFieldWritable) {
                    BgpPathPanel.this.PanelInfo.add("Panel.Bgp4PathAttrMultiExitDisc", this.getbgp4PathAttrMultiExitDiscField());
                }
                if (!((JDMInput)((Object)this.bgp4PathAttrLocalPrefField)).ignoreValue() && this.bgp4PathAttrLocalPrefFieldWritable) {
                    BgpPathPanel.this.PanelInfo.add("Panel.Bgp4PathAttrLocalPref", this.getbgp4PathAttrLocalPrefField());
                }
                if (!((JDMInput)((Object)this.bgp4PathAttrAtomicAggregateField)).ignoreValue() && this.bgp4PathAttrAtomicAggregateFieldWritable) {
                    BgpPathPanel.this.PanelInfo.add("Panel.Bgp4PathAttrAtomicAggregate", this.getbgp4PathAttrAtomicAggregateField());
                }
                if (!((JDMInput)((Object)this.bgp4PathAttrAggregatorASField)).ignoreValue() && this.bgp4PathAttrAggregatorASFieldWritable) {
                    BgpPathPanel.this.PanelInfo.add("Panel.Bgp4PathAttrAggregatorAS", this.getbgp4PathAttrAggregatorASField());
                }
                if (!((JDMInput)((Object)this.bgp4PathAttrAggregatorAddrField)).ignoreValue() && this.bgp4PathAttrAggregatorAddrFieldWritable) {
                    BgpPathPanel.this.PanelInfo.add("Panel.Bgp4PathAttrAggregatorAddr", this.getbgp4PathAttrAggregatorAddrField());
                }
                if (!((JDMInput)((Object)this.bgp4PathAttrCalcLocalPrefField)).ignoreValue() && this.bgp4PathAttrCalcLocalPrefFieldWritable) {
                    BgpPathPanel.this.PanelInfo.add("Panel.Bgp4PathAttrCalcLocalPref", this.getbgp4PathAttrCalcLocalPrefField());
                }
                if (!((JDMInput)((Object)this.bgp4PathAttrBestField)).ignoreValue() && this.bgp4PathAttrBestFieldWritable) {
                    BgpPathPanel.this.PanelInfo.add("Panel.Bgp4PathAttrBest", this.getbgp4PathAttrBestField());
                    return;
                }
            } else {
                BgpPathPanel.this.errorsFound = true;
            }
        }

        public void reset() {
            BgpPathPanel.this.displayMsg(BgpPathPanel.getNLSString("accessDataMsg"));
            try {
                this.setbgp4PathAttrPeerField(BgpPathPanel.this.Bgp4PathAttrTableData.getValueAt("Index.Bgp4PathAttrPeer", BgpPathPanel.this.Bgp4PathAttrTableIndex));
                this.setbgp4PathAttrIpAddrPrefixLenField(BgpPathPanel.this.Bgp4PathAttrTableData.getValueAt("Index.Bgp4PathAttrIpAddrPrefixLen", BgpPathPanel.this.Bgp4PathAttrTableIndex));
                this.setbgp4PathAttrIpAddrPrefixField(BgpPathPanel.this.Bgp4PathAttrTableData.getValueAt("Index.Bgp4PathAttrIpAddrPrefix", BgpPathPanel.this.Bgp4PathAttrTableIndex));
                this.setbgp4PathAttrOriginField(BgpPathPanel.this.Bgp4PathAttrTableData.getValueAt("Panel.Bgp4PathAttrOrigin", BgpPathPanel.this.Bgp4PathAttrTableIndex));
                this.setbgp4PathAttrASPathSegmentField(BgpPathPanel.this.Bgp4PathAttrTableData.getValueAt("Panel.Bgp4PathAttrASPathSegment", BgpPathPanel.this.Bgp4PathAttrTableIndex));
                this.setbgp4PathAttrNextHopField(BgpPathPanel.this.Bgp4PathAttrTableData.getValueAt("Panel.Bgp4PathAttrNextHop", BgpPathPanel.this.Bgp4PathAttrTableIndex));
                this.setbgp4PathAttrMultiExitDiscField(BgpPathPanel.this.Bgp4PathAttrTableData.getValueAt("Panel.Bgp4PathAttrMultiExitDisc", BgpPathPanel.this.Bgp4PathAttrTableIndex));
                this.setbgp4PathAttrLocalPrefField(BgpPathPanel.this.Bgp4PathAttrTableData.getValueAt("Panel.Bgp4PathAttrLocalPref", BgpPathPanel.this.Bgp4PathAttrTableIndex));
                this.setbgp4PathAttrAtomicAggregateField(BgpPathPanel.this.Bgp4PathAttrTableData.getValueAt("Panel.Bgp4PathAttrAtomicAggregate", BgpPathPanel.this.Bgp4PathAttrTableIndex));
                this.setbgp4PathAttrAggregatorASField(BgpPathPanel.this.Bgp4PathAttrTableData.getValueAt("Panel.Bgp4PathAttrAggregatorAS", BgpPathPanel.this.Bgp4PathAttrTableIndex));
                this.setbgp4PathAttrAggregatorAddrField(BgpPathPanel.this.Bgp4PathAttrTableData.getValueAt("Panel.Bgp4PathAttrAggregatorAddr", BgpPathPanel.this.Bgp4PathAttrTableIndex));
                this.setbgp4PathAttrCalcLocalPrefField(BgpPathPanel.this.Bgp4PathAttrTableData.getValueAt("Panel.Bgp4PathAttrCalcLocalPref", BgpPathPanel.this.Bgp4PathAttrTableIndex));
                this.setbgp4PathAttrBestField(BgpPathPanel.this.Bgp4PathAttrTableData.getValueAt("Panel.Bgp4PathAttrBest", BgpPathPanel.this.Bgp4PathAttrTableIndex));
            }
            catch (NullPointerException nullPointerException) {}
            BgpPathPanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.setbgp4PathAttrPeerField(BgpPathPanel.this.Bgp4PathAttrTableData.getValueAt("Index.Bgp4PathAttrPeer", BgpPathPanel.this.Bgp4PathAttrTableIndex));
            this.setbgp4PathAttrIpAddrPrefixLenField(BgpPathPanel.this.Bgp4PathAttrTableData.getValueAt("Index.Bgp4PathAttrIpAddrPrefixLen", BgpPathPanel.this.Bgp4PathAttrTableIndex));
            this.setbgp4PathAttrIpAddrPrefixField(BgpPathPanel.this.Bgp4PathAttrTableData.getValueAt("Index.Bgp4PathAttrIpAddrPrefix", BgpPathPanel.this.Bgp4PathAttrTableIndex));
            this.setbgp4PathAttrOriginField(BgpPathPanel.this.Bgp4PathAttrTableData.getValueAt("Panel.Bgp4PathAttrOrigin", BgpPathPanel.this.Bgp4PathAttrTableIndex));
            this.setbgp4PathAttrASPathSegmentField(BgpPathPanel.this.Bgp4PathAttrTableData.getValueAt("Panel.Bgp4PathAttrASPathSegment", BgpPathPanel.this.Bgp4PathAttrTableIndex));
            this.setbgp4PathAttrNextHopField(BgpPathPanel.this.Bgp4PathAttrTableData.getValueAt("Panel.Bgp4PathAttrNextHop", BgpPathPanel.this.Bgp4PathAttrTableIndex));
            this.setbgp4PathAttrMultiExitDiscField(BgpPathPanel.this.Bgp4PathAttrTableData.getValueAt("Panel.Bgp4PathAttrMultiExitDisc", BgpPathPanel.this.Bgp4PathAttrTableIndex));
            this.setbgp4PathAttrLocalPrefField(BgpPathPanel.this.Bgp4PathAttrTableData.getValueAt("Panel.Bgp4PathAttrLocalPref", BgpPathPanel.this.Bgp4PathAttrTableIndex));
            this.setbgp4PathAttrAtomicAggregateField(BgpPathPanel.this.Bgp4PathAttrTableData.getValueAt("Panel.Bgp4PathAttrAtomicAggregate", BgpPathPanel.this.Bgp4PathAttrTableIndex));
            this.setbgp4PathAttrAggregatorASField(BgpPathPanel.this.Bgp4PathAttrTableData.getValueAt("Panel.Bgp4PathAttrAggregatorAS", BgpPathPanel.this.Bgp4PathAttrTableIndex));
            this.setbgp4PathAttrAggregatorAddrField(BgpPathPanel.this.Bgp4PathAttrTableData.getValueAt("Panel.Bgp4PathAttrAggregatorAddr", BgpPathPanel.this.Bgp4PathAttrTableIndex));
            this.setbgp4PathAttrCalcLocalPrefField(BgpPathPanel.this.Bgp4PathAttrTableData.getValueAt("Panel.Bgp4PathAttrCalcLocalPref", BgpPathPanel.this.Bgp4PathAttrTableIndex));
            this.setbgp4PathAttrBestField(BgpPathPanel.this.Bgp4PathAttrTableData.getValueAt("Panel.Bgp4PathAttrBest", BgpPathPanel.this.Bgp4PathAttrTableIndex));
            this.doLayout();
        }

        public boolean validateSection() {
            return true;
        }
    }

    public class Bgp4PathAttrTable
    extends Table {
        public ModelInfo setRow() {
            return BgpPathPanel.this.Bgp4PathAttrTableInfo;
        }

        public ModelInfo getRow(ModelInfo modelInfo) {
            try {
                while (true) {
                    BgpPathPanel.this.Bgp4PathAttrTableInfo = null;
                    BgpPathPanel.this.displayMsg(BgpPathPanel.getNLSString("startRow"));
                    BgpPathPanel.this.PanelInfo = BgpPathPanel.this.Path_model.getNextInfo("Panel", "default", modelInfo);
                    BgpPathPanel.this.displayMsg(BgpPathPanel.getNLSString("endRow"));
                    if (BgpPathPanel.this.PanelInfo != null) {
                        BgpPathPanel.this.Bgp4PathAttrTableInfo = new ModelInfo();
                        if (BgpPathPanel.this.PanelInfo.isBeingMonitored()) {
                            BgpPathPanel.this.Bgp4PathAttrTableInfo.flagAsMonitored();
                        }
                        Enumeration enumeration = BgpPathPanel.this.PanelInfo.getItemIds();
                        while (enumeration.hasMoreElements()) {
                            String string = (String)enumeration.nextElement();
                            Serializable serializable = BgpPathPanel.this.PanelInfo.get(string);
                            BgpPathPanel.this.Bgp4PathAttrTableInfo.add(string, serializable);
                        }
                    }
                    if (BgpPathPanel.this.Bgp4PathAttrTableInfo != null && !this.validRow(BgpPathPanel.this.Bgp4PathAttrTableInfo)) {
                        modelInfo = BgpPathPanel.this.Bgp4PathAttrTableInfo;
                        continue;
                    }
                    break;
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return BgpPathPanel.this.Bgp4PathAttrTableInfo;
        }

        public ModelInfo getSpecificRow(ModelInfo modelInfo) {
            BgpPathPanel.this.Bgp4PathAttrTableInfo = null;
            try {
                BgpPathPanel.this.displayMsg(BgpPathPanel.getNLSString("startRow"));
                BgpPathPanel.this.PanelInfo = BgpPathPanel.this.Path_model.getInfo("Panel", "default", modelInfo);
                BgpPathPanel.this.displayMsg(BgpPathPanel.getNLSString("endRow"));
                if (BgpPathPanel.this.PanelInfo != null) {
                    BgpPathPanel.this.Bgp4PathAttrTableInfo = new ModelInfo();
                    if (BgpPathPanel.this.PanelInfo.isBeingMonitored()) {
                        BgpPathPanel.this.Bgp4PathAttrTableInfo.flagAsMonitored();
                    }
                    Enumeration enumeration = BgpPathPanel.this.PanelInfo.getItemIds();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        Serializable serializable = BgpPathPanel.this.PanelInfo.get(string);
                        BgpPathPanel.this.Bgp4PathAttrTableInfo.add(string, serializable);
                    }
                }
                if (BgpPathPanel.this.Bgp4PathAttrTableInfo != null && !this.validRow(BgpPathPanel.this.Bgp4PathAttrTableInfo)) {
                    BgpPathPanel.this.Bgp4PathAttrTableInfo = this.getRow(BgpPathPanel.this.Bgp4PathAttrTableInfo);
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return BgpPathPanel.this.Bgp4PathAttrTableInfo;
        }

        public boolean validRow(ModelInfo modelInfo) {
            return true;
        }

        public void setMonitoring(ModelInfo[] modelInfoArray, boolean bl) {
            try {
                if (BgpPathPanel.this.Bgp4PathAttrTableStatus != null) {
                    if (modelInfoArray != null) {
                        if (bl) {
                            BgpPathPanel.this.Bgp4PathAttrTableStatus.monitor(modelInfoArray);
                            return;
                        }
                        BgpPathPanel.this.Bgp4PathAttrTableStatus.doNotMonitor(modelInfoArray);
                        return;
                    }
                    if (bl) {
                        BgpPathPanel.this.Bgp4PathAttrTableStatus.setMaxRows(Integer.MAX_VALUE);
                        return;
                    }
                    BgpPathPanel.this.Bgp4PathAttrTableStatus.setMaxRows(0);
                    return;
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
        }

        public String translateEnum(String string, int n) {
            String string2 = String.valueOf(n);
            return string2;
        }

        public Bgp4PathAttrTable() {
            BgpPathPanel.this = BgpPathPanel.this;
        }
    }
}

